-- Configuraciones para el plugin HogwartsRP Clases
-- Define configuraciones estáticas y dinámicas para gestionar tests y facciones en Helix.

-- Configuraciones estáticas
local CONFIG = {
    FACTIONS_ESTUDIANTES = {"gryffindor", "hufflepuff", "ravenclaw", "slytherin"}, -- UniqueIDs de las facciones de estudiantes (ajustar según tu schema)
    FACTION_PROFESOR = "professor", -- UniqueID para profesores (ajustar según tu schema)
    ITEM_PREFIX = "hechizo_", -- Prefijo para los ítems de hechizos
    TEST_ITEM_BASE = "test_pergamino", -- Ítem base para los tests
    HOUSE_DESCRIPTIONS = {
        gryffindor = "valiente Gryffindor",
        hufflepuff = "leal Hufflepuff",
        ravenclaw = "sabio Ravenclaw",
        slytherin = "astuto Slytherin"
    }
}

-- Configuraciones dinámicas en la pestaña de Helix
ix.config.Add("HogwartsRP_RequiredScore", 80, "Porcentaje mínimo para aprobar un test (0-100).", nil, {
    data = {min = 0, max = 100},
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_MesaModel", "models/props_c17/FurnitureTable001a.mdl", "Modelo de las mesas donde se colocan los pergaminos.", nil, {
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_PergaminoModel", "models/props_c17/paper01.mdl", "Modelo de los pergaminos de los tests.", nil, {
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_SpawnRange", 500, "Rango (en unidades) para spawnear pergaminos en mesas.", nil, {
    data = {min = 100, max = 2000},
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_TestDuration", 3600, "Duración de los tests en segundos antes de eliminarse (0 para infinito).", nil, {
    data = {min = 0, max = 86400},
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_MaxPergaminos", 10, "Número máximo de pergaminos por test.", nil, {
    data = {min = 1, max = 50},
    category = "HogwartsRP"
})

ix.config.Add("HogwartsRP_EntregaRange", 300, "Rango (en unidades) para entregar tests como ítems a estudiantes.", nil, {
    data = {min = 100, max = 2000},
    category = "HogwartsRP"
})

-- Exportar CONFIG para que otros archivos lo usen
ix.clases = ix.clases or {}
ix.clases.CONFIG = CONFIG