-- Ítems para el plugin HogwartsRP Clases
-- Define ítems base para hechizos y tests.

-- Registro del ítem base para hechizos (se crea dinámicamente al aprobar un test)
local function RegisterHechizoItem(test)
    local CONFIG = ix.clases.CONFIG
    local itemID = CONFIG.ITEM_PREFIX .. string.lower(test.hechizo)
    local hechizoItem = ix.item.Register(itemID, nil, false, nil, true)
    hechizoItem.name = "Hechizo: " .. test.hechizo
    hechizoItem.description = "Un pergamino que te permite lanzar " .. test.hechizo .. "."
    hechizoItem.model = ix.config.Get("HogwartsRP_PergaminoModel")
    hechizoItem.category = "Hechizos"
    hechizoItem.functions.Use = {
        OnRun = function(item)
            local client = item.player
            client:Notify("Lanzaste " .. test.hechizo .. "!")
            return false
        end
    }
end