-- Entidad para el plugin HogwartsRP Clases
-- Define la entidad ix_pergamino_test para interactuar con pergaminos físicos.

ENT = {}
ENT.Type = "anim"
ENT.Base = "base_gmodentity"
ENT.PrintName = "Pergamino de Test"
ENT.Category = "HogwartsRP"
ENT.Spawnable = true
ENT.AdminOnly = true

function ENT:Initialize()
    local CONFIG = ix.clases.CONFIG
    self:SetModel(ix.config.Get("HogwartsRP_PergaminoModel"))
    self:PhysicsInit(SOLID_VPHYSICS)
    self:SetMoveType(MOVETYPE_VPHYSICS)
    self:SetSolid(SOLID_VPHYSICS)
    local phys = self:GetPhysicsObject()
    if IsValid(phys) then
        phys:Wake()
        phys:EnableMotion(false)
    end
end

function ENT:Use(activator)
    local CONFIG = ix.clases.CONFIG
    if not activator:IsPlayer() then return end

    local char = activator:GetCharacter()
    if not char then return end

    local studentFactionUniqueID = ix.faction.Get(char:GetFaction()).uniqueID
    if not table.HasValue(CONFIG.FACTIONS_ESTUDIANTES, studentFactionUniqueID) then
        activator:Notify("¡Solo los estudiantes de las cuatro casas pueden usar esto!")
        return
    end

    local test = ix.tests[self.testID]
    if not test then
        activator:Notify("¡Test no encontrado!")
        return
    end

    local clasesCompletadas = char:GetData("clasesCompletadas", {})
    if clasesCompletadas[self.testID] then
        activator:Notify("¡Ya has tomado este test!")
        return
    end

    if SERVER then
        local effect = EffectData()
        effect:SetOrigin(self:GetPos())
        effect:SetMagnitude(1)
        effect:SetScale(1)
        effect:SetRadius(1)
        util.Effect("Sparks", effect)
    end

    net.Start("HogwartsRP_IniciarTest")
        net.WriteUInt(self.testID, 32)
        net.WriteString(test.hechizo)
        net.WriteUInt(test.experiencia, 16)
        net.WriteString(test.clase)
        net.WriteTable(test.preguntas)
    net.Send(activator)

    test.estudiantes[activator] = { respuestas = {}, puntaje = 0 }
end

scripted_ents.Register(ENT, "ix_pergamino_test")