-- Interfaz vgui para el plugin HogwartsRP Clases
-- Maneja la creación y respuesta de tests en el cliente.

if CLIENT then
    -- Fuente temática
    surface.CreateFont("HogwartsRP_Pergamino", {
        font = "Harry P", -- Cambia a una fuente disponible en tu servidor
        size = 20,
        weight = 500,
        antialias = true
    })

    net.Receive("HogwartsRP_CrearTestUI", function()
        local CONFIG = ix.clases.CONFIG
        local hechizo = net.ReadString()
        local experiencia = net.ReadUInt(16)
        local clase = net.ReadString()

        local frame = vgui.Create("DFrame")
        frame:SetSize(600, 600)
        frame:Center()
        frame:SetTitle("Crear Test: " .. hechizo)
        frame:MakePopup()
        frame.Paint = function(s, w, h)
            draw.RoundedBox(0, 0, 0, w, h, Color(200, 170, 100, 255)) -- Fondo de pergamino
            draw.RoundedBox(0, 2, 2, w - 4, h - 4, Color(240, 230, 200, 255)) -- Borde interior
        end

        local scroll = vgui.Create("DScrollPanel", frame)
        scroll:SetSize(580, 500)
        scroll:SetPos(10, 30)
        scroll.Paint = function(s, w, h)
            draw.RoundedBox(0, 0, 0, w, h, Color(240, 230, 200, 255))
        end

        local preguntas = {}
        for i = 1, 10 do
            local panel = scroll:Add("DPanel")
            panel:SetSize(560, 100)
            panel:SetPos(0, (i - 1) * 110)
            panel.Paint = function(s, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(230, 220, 190, 255))
            end

            local label = vgui.Create("DLabel", panel)
            label:SetPos(10, 5)
            label:SetText("Pregunta " .. i .. ":")
            label:SetFont("HogwartsRP_Pergamino")
            label:SizeToContents()

            local pregunta = vgui.Create("DTextEntry", panel)
            pregunta:SetPos(10, 25)
            pregunta:SetSize(540, 20)
            pregunta:SetPlaceholderText("Escribe la pregunta...")
            pregunta:SetFont("HogwartsRP_Pergamino")

            local opciones = {}
            for j = 1, 4 do
                local opcion = vgui.Create("DTextEntry", panel)
                opcion:SetPos(10, 50 + (j - 1) * 20)
                opcion:SetSize(400, 20)
                opcion:SetPlaceholderText("Opción " .. j)
                opcion:SetFont("HogwartsRP_Pergamino")
                opciones[j] = opcion
            end

            local correcta = vgui.Create("DComboBox", panel)
            correcta:SetPos(420, 50)
            correcta:SetSize(130, 20)
            correcta:SetValue("Respuesta Correcta")
            correcta:SetFont("HogwartsRP_Pergamino")
            for j = 1, 4 do
                correcta:AddChoice("Opción " .. j, j)
            end

            preguntas[i] = { pregunta = pregunta, opciones = opciones, correcta = correcta }
        end

        local submit = vgui.Create("DButton", frame)
        submit:SetPos(10, 530)
        submit:SetSize(580, 30)
        submit:SetText("Guardar Test")
        submit:SetFont("HogwartsRP_Pergamino")
        submit.DoClick = function()
            for i, data in ipairs(preguntas) do
                if data.pregunta:GetText() == "" then
                    LocalPlayer():Notify("¡La pregunta " .. i .. " está vacía!")
                    return
                end
                for j, opcion in ipairs(data.opciones) do
                    if opcion:GetText() == "" then
                        LocalPlayer():Notify("¡La opción " .. j .. " de la pregunta " .. i .. " está vacía!")
                        return
                    end
                end
            end

            local preguntasTable = {}
            for i, data in ipairs(preguntas) do
                local opcionesTable = {}
                for j, opcion in ipairs(data.opciones) do
                    opcionesTable[j] = opcion:GetText()
                end
                preguntasTable[i] = {
                    texto = data.pregunta:GetText(),
                    opciones = opcionesTable,
                    respuestaCorrecta = data.correcta:GetSelectedID()
                }
            end

            net.Start("HogwartsRP_GuardarTest")
                net.WriteString(hechizo)
                net.WriteUInt(experiencia, 16)
                net.WriteString(clase)
                net.WriteTable(preguntasTable)
            net.SendToServer()

            frame:Close()
        end
    end)

    net.Receive("HogwartsRP_IniciarTest", function()
        local CONFIG = ix.clases.CONFIG
        local testID = net.ReadUInt(32)
        local hechizo = net.ReadString()
        local experiencia = net.ReadUInt(16)
        local clase = net.ReadString()
        local preguntas = net.ReadTable()

        local frame = vgui.Create("DFrame")
        frame:SetSize(600, 600)
        frame:Center()
        frame:SetTitle("Test de " .. clase .. ": " .. hechizo)
        frame:MakePopup()
        frame.Paint = function(s, w, h)
            draw.RoundedBox(0, 0, 0, w, h, Color(200, 170, 100, 255)) -- Fondo de pergamino
            draw.RoundedBox(0, 2, 2, w - 4, h - 4, Color(240, 230, 200, 255)) -- Borde interior
        end

        local scroll = vgui.Create("DScrollPanel", frame)
        scroll:SetSize(580, 500)
        scroll:SetPos(10, 30)
        scroll.Paint = function(s, w, h)
            draw.RoundedBox(0, 0, 0, w, h, Color(240, 230, 200, 255))
        end

        local respuestas = {}
        for i, pregunta in ipairs(preguntas) do
            local panel = scroll:Add("DPanel")
            panel:SetSize(560, 100)
            panel:SetPos(0, (i - 1) * 110)
            panel.Paint = function(s, w, h)
                draw.RoundedBox(0, 0, 0, w, h, Color(230, 220, 190, 255))
            end

            local label = vgui.Create("DLabel", panel)
            label:SetPos(10, 5)
            label:SetText("Pregunta " .. i .. ": " .. pregunta.texto)
            label:SetWrap(true)
            label:SetSize(540, 40)
            label:SetFont("HogwartsRP_Pergamino")

            local combo = vgui.Create("DComboBox", panel)
            combo:SetPos(10, 50)
            combo:SetSize(540, 20)
            combo:SetValue("Selecciona una opción...")
            combo:SetFont("HogwartsRP_Pergamino")
            for j, opcion in ipairs(pregunta.opciones) do
                combo:AddChoice(opcion, j)
            end
            respuestas[i] = combo
        end

        local submit = vgui.Create("DButton", frame)
        submit:SetPos(10, 530)
        submit:SetSize(580, 30)
        submit:SetText("Enviar Respuestas")
        submit:SetFont("HogwartsRP_Pergamino")
        submit.DoClick = function()
            local respuestasTable = {}
            for i, combo in ipairs(respuestas) do
                respuestasTable[i] = combo:GetSelectedID()
            end

            net.Start("HogwartsRP_EnviarRespuestas")
                net.WriteUInt(testID, 32)
                net.WriteTable(respuestasTable)
            net.SendToServer()

            frame:Close()
        end
    end)
end