-- Comandos para el plugin HogwartsRP Clases
-- Incluye /DevPruebaTest, /CrearTest, /ColocarTest y /EntregarTest.

ix.command.Add("DevPruebaTest", {
    description = "Crea tests predefinidos para pruebas (solo admins)",
    adminOnly = true,
    OnRun = function(self, client)
        local CONFIG = ix.clases.CONFIG
        local createdTests = {}
        for clase, tests in pairs(PREDEFINED_TESTS) do
            for _, testData in ipairs(tests) do
                local testID = os.time() + math.random(1, 1000)
                ix.tests[testID] = {
                    hechizo = testData.hechizo,
                    experiencia = testData.experiencia,
                    clase = clase,
                    creador = client,
                    preguntas = testData.preguntas,
                    estudiantes = {}
                }
                table.insert(createdTests, { id = testID, hechizo = testData.hechizo, clase = clase })
                if ix.config.Get("HogwartsRP_TestDuration") > 0 then
                    timer.Simple(ix.config.Get("HogwartsRP_TestDuration"), function()
                        ix.tests[testID] = nil
                    end)
                end
            end
        end

        client:Notify("Tests predefinidos creados:")
        for _, test in ipairs(createdTests) do
            client:Notify("ID: " .. test.id .. " | Hechizo: " .. test.hechizo .. " | Clase: " .. test.clase)
        end
        ix.chat.Send(client, "yell", "¡Tests de prueba creados! Los pergaminos aparecerán mágicamente con /ColocarTest <ID> o /EntregarTest <ID>.")
    end
})

ix.command.Add("CrearTest", {
    description = "Crea un test teórico con interfaz",
    arguments = {
        ix.type.string, -- Hechizo
        ix.type.number, -- Experiencia
        ix.type.string  -- Clase/Asignatura
    },
    OnRun = function(self, client, hechizo, experiencia, clase)
        local CONFIG = ix.clases.CONFIG
        local char = client:GetCharacter()
        local faction = char:GetFaction()

        if faction != ix.faction.Get(CONFIG.FACTION_PROFESOR).uniqueID then
            client:Notify("¡Solo los profesores pueden crear tests!")
            return
        end

        if not hechizo or not experiencia or not clase then
            client:Notify("Uso: /CrearTest <hechizo> <experiencia> <clase>")
            return
        end

        net.Start("HogwartsRP_CrearTestUI")
            net.WriteString(hechizo)
            net.WriteUInt(experiencia, 16)
            net.WriteString(clase)
        net.Send(client)
    end
})

ix.command.Add("ColocarTest", {
    description = "Coloca pergaminos en mesas cercanas para un test",
    arguments = {ix.type.number},
    OnRun = function(self, client, testID)
        local CONFIG = ix.clases.CONFIG
        local test = ix.tests[testID]
        if not test then
            client:Notify("¡Test no encontrado!")
            return
        end

        local char = client:GetCharacter()
        local faction = char:GetFaction()
        if faction != ix.faction.Get(CONFIG.FACTION_PROFESOR).uniqueID then
            client:Notify("¡Solo los profesores pueden colocar tests!")
            return
        end

        local mesaModel = IsValidModel(ix.config.Get("HogwartsRP_MesaModel")) and ix.config.Get("HogwartsRP_MesaModel") or "models/props_c17/FurnitureTable001a.mdl"
        local pergaminoModel = IsValidModel(ix.config.Get("HogwartsRP_PergaminoModel")) and ix.config.Get("HogwartsRP_PergaminoModel") or "models/props_c17/paper01.mdl"
        local spawnRange = ix.config.Get("HogwartsRP_SpawnRange")
        local maxPergaminos = ix.config.Get("HogwartsRP_MaxPergaminos")

        local pos = client:GetPos()
        local mesas = ents.FindInSphere(pos, spawnRange)
        local count = 0
        for _, ent in ipairs(mesas) do
            if ent:GetModel() == mesaModel and count < maxPergaminos then
                local pergamino = ents.Create("ix_pergamino_test")
                pergamino:SetPos(ent:GetPos() + Vector(0, 0, 10))
                pergamino:SetModel(pergaminoModel)
                pergamino:Spawn()
                pergamino.testID = testID
                count = count + 1
            end
        end

        if count > 0 then
            client:Notify(count .. " pergaminos colocados en mesas cercanas.")
            ix.chat.Send(client, "yell", "¡Examen listo! Los pergaminos han aparecido mágicamente en las mesas del aula.")
        else
            client:Notify("No se encontraron mesas cercanas.")
        end
    end
})

ix.command.Add("EntregarTest", {
    description = "Entrega un test como ítem a estudiantes en un radio configurable (opcional: especificar una casa)",
    arguments = {
        ix.type.number,
        bit.bor(ix.type.string, ix.type.optional) -- Casa opcional
    },
    OnRun = function(self, client, testID, house)
        local CONFIG = ix.clases.CONFIG
        local test = ix.tests[testID]
        if not test then
            client:Notify("¡Test no encontrado!")
            return
        end

        local char = client:GetCharacter()
        local faction = char:GetFaction()
        if faction != ix.faction.Get(CONFIG.FACTION_PROFESOR).uniqueID then
            client:Notify("¡Solo los profesores pueden entregar tests!")
            return
        end

        local entregaRange = ix.config.Get("HogwartsRP_EntregaRange")
        local pos = client:GetPos()
        local estudiantes = ents.FindInSphere(pos, entregaRange)
        local count = 0
        local targetHouse = house and string.lower(house) or nil

        for _, ply in ipairs(estudiantes) do
            if ply:IsPlayer() and ply:GetCharacter() then
                local studentChar = ply:GetCharacter()
                local studentFactionUniqueID = ix.faction.Get(studentChar:GetFaction()).uniqueID
                if table.HasValue(CONFIG.FACTIONS_ESTUDIANTES, studentFactionUniqueID) then
                    if not targetHouse or studentFactionUniqueID == targetHouse then
                        local clasesCompletadas = studentChar:GetData("clasesCompletadas", {})
                        if not clasesCompletadas[testID] then
                            local inventory = studentChar:GetInventory()
                            local hasTest = false
                            for _, item in pairs(inventory:GetItems()) do
                                if item.testID == testID then
                                    hasTest = true
                                    break
                                end
                            end

                            if not hasTest then
                                local success, error = inventory:Add(CONFIG.TEST_ITEM_BASE, 1, {testID = testID})
                                if success then
                                    local houseDesc = CONFIG.HOUSE_DESCRIPTIONS[studentFactionUniqueID] or "mago"
                                    ply:Notify("Has recibido un pergamino de examen para " .. test.clase .. ": " .. test.hechizo .. ", digno de un " .. houseDesc .. ".")
                                    count = count + 1
                                else
                                    ply:Notify("No se pudo entregar el pergamino: " .. (error or "inventario lleno."))
                                end
                            end
                        end
                    end
                end
            end
        end

        if count > 0 then
            local houseMsg = targetHouse and " a estudiantes de " .. string.capitalize(targetHouse) or ""
            client:Notify(count .. " pergaminos de examen entregados" .. houseMsg .. " cercanos.")
            ix.chat.Send(client, "yell", "¡El profesor ha entregado los pergaminos de examen" .. houseMsg .. "!")
        else
            client:Notify("No se encontraron estudiantes válidos en el radio o ya tienen el test.")
        end
    end
})