# Instrucciones para instalar y configurar el plugin HogwartsRP Clases en Helix

## Paso 1: Crear el directorio del plugin
- Crea una carpeta llamada "hogwartsrp_clases" en la ruta garrysmod/addons/helix/plugins/.
- Ruta completa: garrysmod/addons/helix/plugins/hogwartsrp_clases.

## Paso 2: Guardar los archivos
- Guarda los siguientes archivos en la carpeta "hogwartsrp_clases":
  - sh_plugin.lua
  - sh_config.lua
  - sh_commands.lua
  - sh_entity.lua
  - sh_items.lua
  - sh_net.lua
  - cl_vgui.lua
  - sv_init.lua
- Asegúrate de que los archivos tengan la extensión .lua.

## Paso 3: Configurar las facciones
- Abre "sh_config.lua" y verifica/adapta la tabla CONFIG.FACTIONS_ESTUDIANTES con los uniqueID de tus facciones de casas (e.g., {"gryffindor", "hufflepuff", "ravenclaw", "slytherin"}). Estos deben coincidir con los uniqueID definidos en tu schema (sh_factions.lua).
- Edita CONFIG.FACTION_PROFESOR con el uniqueID de la facción de profesores (e.g., "professor").
- Edita CONFIG.HOUSE_DESCRIPTIONS si quieres personalizar las descripciones de las casas para notificaciones.

## Paso 4: Verificar los uniqueID
- Si no estás seguro de los uniqueID de tus facciones, ejecuta en la consola del servidor:
  - `lua_run for k, v in pairs(ix.faction.indices) do print(k, v.uniqueID) end`
- Ajusta CONFIG.FACTIONS_ESTUDIANTES con los valores correctos (en minúsculas).

## Paso 5: Configurar la fuente temática
- La interfaz usa la fuente "Harry P". Descárgala desde dafont.com/harry-p.font y añádela al servidor como resource pack.
- Si no está disponible, cambia "Harry P" en cl_vgui.lua (surface.CreateFont) a una fuente predeterminada como "Trebuchet24".

## Paso 6: Instalar y probar
- Reinicia el servidor para cargar el plugin.
- Como administrador, usa /DevPruebaTest para generar 14 tests predefinidos (2 por asignatura).
- Usa /CrearTest para crear un test personalizado.
- Usa /ColocarTest <ID> para spawnear pergaminos en mesas.
- Usa /EntregarTest <ID> [casa] para entregar ítems a estudiantes en el radio (opcional: especificar casa, e.g., "gryffindor").
- Como estudiante de una casa, interactúa con un pergamino (+use) o usa el ítem para tomar el test.
- Ajusta las variables en el menú de configuración de Helix (categoría "HogwartsRP").

## Paso 7: Depuración
- Añade print en los net messages (e.g., en sh_net.lua) para depurar.
- Verifica las facciones en tu schema (sh_factions.lua) y asegúrate de que los uniqueID coincidan con CONFIG.FACTIONS_ESTUDIANTES.

## Paso 8: Personalización adicional
- Para texturas reales en la interfaz, crea un material .vtf y usa surface.SetMaterial en cl_vgui.lua (Paint de vgui).
- Para sonidos, añade sound.Add y EmitSound en sh_entity.lua (ENT:Use) o sh_items.lua (item.functions.Use).
- Si necesitas más ayuda, consulta la consola del servidor o contacta al equipo de desarrollo.

¡Que la magia de Helix y HogwartsRP te acompañe en esta aventura!
