-- Net messages para el plugin HogwartsRP Clases
-- Maneja la comunicación cliente-servidor para crear y responder tests.

if SERVER then
    util.AddNetworkString("HogwartsRP_CrearTestUI")
    util.AddNetworkString("HogwartsRP_GuardarTest")
    util.AddNetworkString("HogwartsRP_IniciarTest")
    util.AddNetworkString("HogwartsRP_EnviarRespuestas")

    net.Receive("HogwartsRP_GuardarTest", function(len, client)
        local CONFIG = ix.clases.CONFIG
        local hechizo = net.ReadString()
        local experiencia = net.ReadUInt(16)
        local clase = net.ReadString()
        local preguntas = net.ReadTable()

        local char = client:GetCharacter()
        if char:GetFaction() != ix.faction.Get(CONFIG.FACTION_PROFESOR).uniqueID then
            client:Notify("¡No tienes permiso para crear tests!")
            return
        end

        local testID = os.time()
        ix.tests[testID] = {
            hechizo = hechizo,
            experiencia = experiencia,
            clase = clase,
            creador = client,
            preguntas = preguntas,
            estudiantes = {}
        }

        if ix.config.Get("HogwartsRP_TestDuration") > 0 then
            timer.Simple(ix.config.Get("HogwartsRP_TestDuration"), function()
                ix.tests[testID] = nil
            end)
        end

        client:Notify("Test guardado con ID: " .. testID)
    end)

    net.Receive("HogwartsRP_EnviarRespuestas", function(len, client)
        local CONFIG = ix.clases.CONFIG
        local testID = net.ReadUInt(32)
        local respuestas = net.ReadTable()
        local test = ix.tests[testID]

        if not test or not test.estudiantes[client] then
            client:Notify("¡Error: Test no válido!")
            return
        end

        local requiredScore = ix.config.Get("HogwartsRP_RequiredScore")
        local puntaje = 0
        for i, respuesta in ipairs(respuestas) do
            if respuesta == test.preguntas[i].respuestaCorrecta then
                puntaje = puntaje + 10
            end
        end

        test.estudiantes[client].puntaje = puntaje
        local char = client:GetCharacter()
        local clasesCompletadas = char:GetData("clasesCompletadas", {})
        clasesCompletadas[testID] = true
        char:SetData("clasesCompletadas", clasesCompletadas)

        if puntaje >= requiredScore then
            char:GiveExperience(test.experiencia)
            client:Notify("¡Aprobaste el test! Ganaste " .. test.experiencia .. " EXP.")
            RegisterHechizoItem(test) -- Registrar y añadir el ítem del hechizo
            char:GetInventory():Add(CONFIG.ITEM_PREFIX .. string.lower(test.hechizo))

            local hechizosAprendidos = char:GetData("hechizosAprendidos", {})
            hechizosAprendidos[test.hechizo] = true
            char:SetData("hechizosAprendidos", hechizosAprendidos)
        else
            client:Notify("No aprobaste el test. ¡Estudia más, joven mago!")
        end

        test.estudiantes[client] = nil
    end)
end