-- =======================================================================================
-- Evento: Cápsula de Escape Estrellada (Clone Wars)
-- Fichero: sh_cw_escapepod.lua
-- =======================================================================================

local EVENT = {}

-- 1. METADATOS: Información básica del evento.
EVENT.id = "cw_escapepod"
EVENT.name = "Cápsula de Escape Estrellada"
EVENT.description = "Una cápsula de escape de la República se ha estrellado. ¡La República debe rescatar al piloto, la CSI debe capturarlo para obtener inteligencia!"

-- 2. PROPUESTA AL STAFF: Mensaje que verán los administradores.
EVENT.proposal = {
    message = "Inteligencia sugiere que una cápsula de escape republicana se estrellará pronto. ¿Lanzamos el evento de rescate?",
    timeout = 60
}

-- 3. CONDICIONES DE ACTIVACIÓN: Reglas para que el "Director" pueda proponer este evento.
EVENT.minPlayers = 6
EVENT.factions = { FACTION_REPUBLIC, FACTION_CIS }

-- 4. PARÁMETROS DE EJECUCIÓN: Dónde y cómo ocurre el evento.
EVENT.duration = 900 -- 15 minutos máximo antes de que el evento fracase.
EVENT.positions = {
    -- ¡IMPORTANTE! Debes cambiar estas coordenadas a lugares de tu mapa donde una cápsula pueda estrellarse.
    Vector(1234, 5678, 128),
    Vector(-4321, -1234, 128),
    Vector(3000, -2500, 128)
}

-- 5. LÓGICA DEL SERVIDOR (Las 3 Funciones Clave):

-- Se ejecuta UNA VEZ al inicio del evento.
EVENT.OnStart = function(position)
    -- Creamos la cápsula estrellada (usando un modelo de placeholder, deberías cambiarlo).
    local pod = ents.Create("prop_physics")
    if (IsValid(pod)) then
        -- CAMBIA ESTE MODELO por uno de una cápsula de escape real que tengas en tu servidor.
        pod:SetModel("models/props_junk/cinderblock01a.mdl")
        pod:SetPos(position)
        pod:Spawn()
        pod:SetCollisionGroup(COLLISION_GROUP_DEBRIS)
        pod:GetPhysicsObject():EnableMotion(false) -- Para que no se mueva.
    end

    -- Creamos al piloto (un PNJ).
    local pilot = ents.Create("npc_citizen")
    if (IsValid(pilot)) then
        pilot:SetPos(position + Vector(50, 0, 0))
        pilot:SetModel("models/player/police.mdl") -- CAMBIA ESTE MODELO por uno de piloto de la República.
        pilot:Spawn()
        pilot:SetHealth(150)
        pilot:SetMaxHealth(150)
        pilot:Give("weapon_pistol") -- Le damos un arma para que pueda defenderse un poco.

        -- Hacemos que siga a los jugadores de la República y huya de la CSI.
        pilot:SetIdealRelation(FACTION_REPUBLIC, D_LI)
        pilot:SetIdealRelation(FACTION_CIS, D_FR)

        -- Le decimos que vaya a la base de la República.
        -- ¡IMPORTANTE! Cambia estas coordenadas por las de la base de la República en tu mapa.
        local republicBasePos = Vector(0, 0, 128)
        pilot:SetSchedule(SCHED_MOVE_TO_TARGET)
        pilot:SetTarget(republicBasePos)
    end

    -- Devolvemos las entidades clave que hemos creado.
    return { pod = pod, pilot = pilot }
end

-- Se ejecuta CADA POCOS SEGUNDOS para comprobar el estado del objetivo.
EVENT.ObjectiveCheck = function(entities)
    -- Si el piloto ya no es válido (ha muerto o ha sido eliminado), el evento fracasa.
    if (!IsValid(entities.pilot)) then
        return { status = "fail", reason = "El piloto ha sido eliminado." }
    end

    -- Condición de victoria de la República: el piloto llega a su base.
    local republicBasePos = Vector(0, 0, 128) -- La misma coordenada que en OnStart.
    if (entities.pilot:GetPos():Distance(republicBasePos) < 500) then -- Si está a menos de 500 unidades de la base.
        return { status = "win", winner = FACTION_REPUBLIC }
    end

    -- Condición de victoria de la CSI: capturan al piloto.
    -- Para este ejemplo, consideraremos "capturado" si un jugador de la CSI se acerca y pulsa 'E'.
    for _, ply in ipairs(player.GetHumans({FACTION_CIS})) do
        if (ply:Alive() and ply:GetPos():Distance(entities.pilot:GetPos()) < 150 and ply:KeyDown(IN_USE)) then
            return { status = "win", winner = FACTION_CIS }
        end
    end

    -- Si no se cumple ninguna condición, el evento continúa.
    return nil
end

-- Se ejecuta UNA VEZ al final del evento.
EVENT.OnEnd = function(result, entities)
    -- Damos las recompensas y limpiamos las entidades.
    if (result.status == "win") then
        if (result.winner == FACTION_REPUBLIC) then
            ix.util.NotifyAll("¡Misión Cumplida! El piloto de la República ha sido rescatado.", Color(0, 255, 0))
            -- Recompensa: Damos 1000 créditos a todos los jugadores de la República.
            for _, ply in ipairs(player.GetHumans({FACTION_REPUBLIC})) do
                ply:GetCharacter():AddMoney(1000)
            end
        elseif (result.winner == FACTION_CIS) then
            ix.util.NotifyAll("¡Misión Cumplida! El piloto ha sido capturado por la CSI.", Color(255, 0, 0))
            -- Recompensa: Damos 1500 créditos a todos los jugadores de la CSI por la inteligencia obtenida.
            for _, ply in ipairs(player.GetHumans({FACTION_CIS})) do
                ply:GetCharacter():AddMoney(1500)
            end
        end
    else
        ix.util.NotifyAll("Misión Fracasada: "..(result.reason or "El tiempo se ha agotado."), Color(255, 150, 0))
    end

    -- Limpiamos las entidades que creamos para que no se queden en el mapa.
    if (IsValid(entities.pod)) then entities.pod:Remove() end
    if (IsValid(entities.pilot)) then entities.pilot:Remove() end
end

-- 6. LÓGICA DEL CLIENTE: ¿Qué ve el jugador en el HUD?
EVENT.HUDInfo = function(entities)
    if (IsValid(entities.pilot)) then
        return "Objetivo: Escolta al piloto a la base\nSalud del Piloto: "..entities.pilot:Health().." / "..entities.pilot:GetMaxHealth()
    end
    return "Objetivo: El piloto ha sido eliminado."
end

-- No olvidar registrar el evento al final del fichero.
PLUGIN:RegisterEvent(EVENT)

