-- =======================================================================================
-- Evento: Criatura Mágica Rara (Hogwarts RP)
-- Fichero: sh_hp_creature.lua
-- =======================================================================================

local EVENT = {}

-- 1. METADATOS
EVENT.id = "hp_creature"
EVENT.name = "Criatura Mágica Rara Avistada"
EVENT.description = "¡Un Hipogrifo ha sido avistado en el Bosque Prohibido! Los estudiantes pueden estudiarlo para ganar puntos para su casa. ¡Cuidado con los cazadores furtivos!"

-- 2. PROPUESTA AL STAFF
EVENT.proposal = {
    message = "Nuestros sensores mágicos detectan una criatura rara en el Bosque Prohibido. ¿Iniciamos el evento de estudio/captura?",
    timeout = 60
}

-- 3. CONDICIONES DE ACTIVACIÓN
EVENT.minPlayers = 4
-- Asumimos que los estudiantes son una facción y los mortífagos/cazadores son otra.
EVENT.factions = { FACTION_STUDENT, FACTION_DEATHEATER }

-- 4. PARÁMETROS DE EJECUCIÓN
EVENT.duration = 600 -- 10 minutos.
EVENT.positions = {
    -- ¡IMPORTANTE! Coordenadas de lugares del Bosque Prohibido en tu mapa.
    Vector(-2000, -3000, 50),
    Vector(-2500, -3500, 50),
}

-- 5. LÓGICA DEL SERVIDOR

-- Se ejecuta UNA VEZ al inicio del evento.
EVENT.OnStart = function(position)
    -- Creamos la criatura.
    local creature = ents.Create("npc_antlion") -- CAMBIA ESTE MODELO por uno de Hipogrifo.
    if (IsValid(creature)) then
        creature:SetPos(position)
        creature:SetModel("models/antlion.mdl")
        creature:Spawn()
        creature:SetHealth(300)
        creature:SetMaxHealth(300)
        creature:SetSchedule(SCHED_IDLE_WANDER) -- Para que se mueva un poco por la zona.

        -- Variables personalizadas para rastrear el progreso.
        creature.studyProgress = 0
        creature.maxStudy = 500
    end

    return { creature = creature }
end

-- Se ejecuta CADA POCOS SEGUNDOS para comprobar el estado del objetivo.
EVENT.ObjectiveCheck = function(entities)
    local creature = entities.creature
    if (!IsValid(creature)) then
        return { status = "fail", reason = "La criatura ha desaparecido." }
    end

    -- Lógica de "Estudio" para los estudiantes.
    -- Por cada estudiante cerca pulsando 'E', el progreso aumenta.
    for _, ply in ipairs(player.GetHumans({FACTION_STUDENT})) do
        if (ply:Alive() and ply:GetPos():Distance(creature:GetPos()) < 200 and ply:KeyDown(IN_USE)) then
            creature.studyProgress = creature.studyProgress + 1
        end
    end

    -- Condición de victoria de los Estudiantes: el estudio se completa.
    if (creature.studyProgress >= creature.maxStudy) then
        return { status = "win", winner = FACTION_STUDENT }
    end

    -- Condición de victoria de los Mortífagos ("Captura"): deben bajar la vida de la criatura por debajo del 10%.
    if (creature:Health() < 30) then
        return { status = "win", winner = FACTION_DEATHEATER }
    end

    return nil
end

-- Se ejecuta UNA VEZ al final del evento.
EVENT.OnEnd = function(result, entities)
    if (result.status == "win") then
        if (result.winner == FACTION_STUDENT) then
            ix.util.NotifyAll("¡Estudio completado! Los estudiantes han documentado con éxito al Hipogrifo.", Color(0, 255, 0))
            -- Recompensa: Dar 10 Puntos de Casa a cada estudiante.
            for _, ply in ipairs(player.GetHumans({FACTION_STUDENT})) do
                -- Suponiendo que tienes un sistema de puntos de casa.
                -- ply:GetCharacter():AddHousePoints(10)
                ply:Notify("Has ganado 10 Puntos de Casa para tu casa.")
            end
        elseif (result.winner == FACTION_DEATHEATER) then
            ix.util.NotifyAll("¡Captura completada! El Hipogrifo ha sido sometido por las Fuerzas Oscuras.", Color(255, 0, 0))
            -- Recompensa: Dar un item "Corazón de Hipogrifo" a cada participante.
            for _, ply in ipairs(player.GetHumans({FACTION_DEATHEATER})) do
                ply:GetCharacter():GetInventory():Add("hippogriff_heart")
                ply:Notify("Has obtenido un 'Corazón de Hipogrifo'.")
            end
        end
    else
        ix.util.NotifyAll("Misión Fracasada: "..(result.reason or "El tiempo se ha agotado."), Color(255, 150, 0))
    end

    -- Limpiamos la criatura.
    if (IsValid(entities.creature)) then entities.creature:Remove() end
end

-- 6. LÓGICA DEL CLIENTE: ¿Qué ve el jugador en el HUD?
EVENT.HUDInfo = function(entities)
    local creature = entities.creature
    if (IsValid(creature)) then
        local studyPercent = math.Round((creature.studyProgress / creature.maxStudy) * 100)
        return "Objetivo: Estudia a la criatura o captúrala\nProgreso de Estudio: "..studyPercent.."%\nSalud de la Criatura: "..creature:Health()
    end
end

-- No olvidar registrar el evento al final del fichero.
PLUGIN:RegisterEvent(EVENT)