# Roadmap de Migración - HogwartsRP (DarkRP → Helix)

## 🧭 Objetivo
Migrar el ecosistema `CC3-Master` (DarkRP) a **Helix**, manteniendo todas las funcionalidades principales del servidor HogwartsRP.

---

## 🧩 1. Mapa Global de Addons

| Categoría | Addons | Qué hacen ahora (DarkRP) | Qué harán en Helix |
|------------|--------|---------------------------|--------------------|
| Gamemode base | DarkRP | Núcleo RP (economía, chat, jobs) | Sustituido por Helix (schema + plugins) |
| Core del servidor | core_houses, core_classes, core_economy, core_shops, core_store, core_pets | Facciones, economía, tiendas, mascotas | Plugins Helix con ix.faction, ix.item, ix.currency |
| Magia | core_spells (HPWRewrite) | Hechizos y efectos | Plugin Helix ix_spells (NetStreams, facciones) |
| Economía / Comercio | core_shops, core_store | Tiendas DarkRPVars | ix.currency + ix.vendor |
| Administración | sam_148, blogs, blog_gas | Admin y logs | ix.permissions + ix.log |
| Frameworks | lib_xenin_framework, zclib, HPWRewrite, GAS, SAM | Librerías base | Mantener temporalmente |
| Eventos | zeros_masterchef, zeros_pumpkinnight | Minijuegos | Plugins Helix (ix.event) |
| Inventarios | core_itemstore, core_store | Persistencia ítems | ix.item + ix.inventory |
| Social / Gangs | core_gangs_clubs | Clubes DarkRP | ix.faction + plugin clubs |
| Interfaz | lib_xenin_framework, core_hud | UIs Xenin | UI Helix |
| Casas de Hogwarts | core_houses | Equipos DarkRP | ix.faction + puntuación |
| Utilidades | util_drgbase, ent_mediaplayer | IA y multimedia | Plugins Helix |
| Seguridad / Logs | core_logger, awarn3 | Logs y warns | ix.log |

---

## 🧩 2. Dependencias

| Dependencia | Usado por | Acción en migración |
|--------------|------------|---------------------|
| DarkRP | todos los core_* | Reemplazar por APIs Helix |
| mysqloo/tmysql4 | economía, itemstore | Sustituir por ix.data |
| zclib | zeros_* y core_spells | Mantener con wrapper |
| HPWRewrite | core_spells | Integrar plugin Helix |
| Xenin Framework | UI y tiendas | Reescribir en Helix |
| SAM y GAS | admin y logs | Fusionar en ix.admin |
| ItemStore | core_itemstore | Migrar a ix.inventory |
| DrGBase | IA | Mantener si se usa |

---

## 🧩 3. Roadmap de Migración

### Fase 1 — Preparación
- Limpiar repos, eliminar credenciales DB.
- Instalar Helix base.
- Configurar MySQL persistencia.
- Verificar módulos binarios.

### Fase 2 — Núcleo Helix
- Portar economía, casas, clases.
- Crear plugin ix_housesystem.
- Añadir persistencia Helix.

### Fase 3 — Jugabilidad esencial
- Portar magia y varita.
- Portar tiendas y economía.
- Portar inventario.

### Fase 4 — Sistemas secundarios
- Portar pets, UI, clubs.
- Adaptar UIs a Helix GUI.
- Crear wrapper zclib temporal.

### Fase 5 — Administración y eventos
- Migrar SAM y GAS a ix.admin.
- Añadir webhooks Discord.
- Portar zeros_* como eventos.

### Fase 6 — Limpieza final
- Eliminar dependencias DarkRP.
- Sustituir Xenin y zclib.
- Optimizar hooks y netcode.

---

## 🔍 4. Prioridades

| Nivel | Dependencia | Acción |
|--------|--------------|--------|
| 🔴 Crítico | DarkRP, SAM, GAS | Eliminar |
| 🟠 Alto | zclib, Xenin | Sustituir |
| 🟢 Medio | mysqloo/tmysql4 | Mantener temporal |
| 🔵 Bajo | HPWRewrite | Integrar plugin |
| ⚪ Opcional | zeros_* | Portar según uso |

---

## 💾 5. Resultado Final
Schema **Helix HogwartsRP**, modular, sin dependencias DarkRP:
```
gamemodes/helix/schema/
├── plugins/
│   ├── houses
│   ├── spells
│   ├── shops
│   ├── economy
│   ├── inventory
│   ├── events
│   ├── admin
│   └── ui
```
